/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.helpers.IConfigInvHost;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.parts.PartModel;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class IOBusPart
extends UpgradeablePart
implements IGridTickable,
IConfigInvHost {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("ae2", "part/import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new ResourceLocation("ae2", "part/import_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new ResourceLocation("ae2", "part/import_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new ResourceLocation("ae2", "part/import_bus_has_channel"));
    private final ConfigInventory config;
    @Nullable
    private IPartitionList filter;
    private final TickRates tickRates;
    protected final IActionSource source;
    private boolean lastRedstone = false;
    private boolean pendingPulse = false;

    public IOBusPart(TickRates tickRates, IPartItem<?> partItem) {
        super(partItem);
        this.tickRates = tickRates;
        this.source = new MachineSource(this);
        this.config = ConfigInventory.configTypes(StackWorldBehaviors.hasImportStrategyFilter(), 9, this::updateState);
        this.getMainNode().addService(IGridTickable.class, this);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
    }

    @Override
    public RedstoneMode getRSMode() {
        return this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    private boolean isInPulseMode() {
        return this.getRSMode() == RedstoneMode.SIGNAL_PULSE;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    protected abstract MenuType<?> getMenuType();

    @Override
    public void upgradesChanged() {
        this.updateState();
    }

    @Override
    public void readFromNBT(CompoundTag extra) {
        super.readFromNBT(extra);
        this.config.readFromChildTag(extra, "config");
        this.filter = null;
        this.pendingPulse = this.isInPulseMode() && extra.m_128471_("pendingPulse");
    }

    @Override
    public void writeToNBT(CompoundTag extra) {
        super.writeToNBT(extra);
        this.config.writeToChildTag(extra, "config");
        if (this.isInPulseMode() && this.pendingPulse) {
            extra.m_128379_("pendingPulse", true);
        }
    }

    @Override
    public ConfigInventory getConfig() {
        return this.config;
    }

    protected final IPartitionList getFilter() {
        if (this.filter == null) {
            IPartitionList.Builder filterBuilder = IPartitionList.builder();
            filterBuilder.addAll(this.getConfig().keySet());
            if (this.isUpgradedWith(AEItems.FUZZY_CARD)) {
                filterBuilder.fuzzyMode(this.getConfigManager().getSetting(Settings.FUZZY_MODE));
            }
            this.filter = filterBuilder.build();
        }
        return this.filter;
    }

    @Override
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (this.isInPulseMode()) {
            boolean hostIsPowered = this.getHost().hasRedstone();
            if (this.lastRedstone != hostIsPowered) {
                this.lastRedstone = hostIsPowered;
                if (this.lastRedstone && !this.pendingPulse) {
                    this.pendingPulse = true;
                    this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
                }
            }
        } else {
            this.updateRedstoneState();
        }
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(AEItems.CAPACITY_CARD) * 4, this.getConfig().size());
    }

    protected int getOperationsPerTick() {
        return switch (this.getInstalledUpgrades(AEItems.SPEED_CARD)) {
            default -> 1;
            case 1 -> 8;
            case 2 -> 32;
            case 3 -> 64;
            case 4 -> 96;
        };
    }

    @Override
    public final TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.pendingPulse = false;
        boolean hasDoneWork = this.doBusWork(node.getGrid());
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        return hasDoneWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    protected final boolean canDoBusWork() {
        if (!this.getMainNode().isActive()) {
            return false;
        }
        BlockEntity self = this.getHost().getBlockEntity();
        BlockPos targetPos = self.m_58899_().m_142300_(this.getSide());
        return Platform.areBlockEntitiesTicking(self.m_58904_(), targetPos);
    }

    private void updateState() {
        this.filter = null;
        this.updateRedstoneState();
    }

    @Override
    protected void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        super.onSettingChanged(manager, setting);
        this.updateRedstoneState();
        if (this.isInPulseMode()) {
            this.lastRedstone = this.getHost().hasRedstone();
        }
    }

    private void updateRedstoneState() {
        if (!this.isInPulseMode()) {
            this.pendingPulse = false;
        }
        this.getMainNode().ifPresent((grid, node) -> {
            if (!this.isSleeping()) {
                grid.getTickManager().wakeDevice((IGridNode)node);
            } else {
                grid.getTickManager().sleepDevice((IGridNode)node);
            }
        });
    }

    @Override
    public final boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!this.isClientSide()) {
            MenuOpener.open(this.getMenuType(), player, MenuLocators.forPart(this));
        }
        return true;
    }

    @Override
    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(this.tickRates.getMin(), this.tickRates.getMax(), this.isSleeping(), true);
    }

    @Override
    protected boolean isSleeping() {
        if (this.isInPulseMode() && this.pendingPulse) {
            return false;
        }
        return super.isSleeping();
    }

    protected abstract boolean doBusWork(IGrid var1);

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.lastRedstone = this.getHost().hasRedstone();
        if (this.pendingPulse) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }
}

